<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
class DashboardController extends Controller
{
    function summary(){
		$data['title'] = "Summary";
		$data['title2'] = "Parking income summary for daily, weekly and monthly";
		$today = Carbon::today();
		$start = $today->copy()->subDays(7);
		
		$sync = DB::table("sync_log")->first();
		$data['lastSync'] = $sync->dt_sync;
		
		//kendaraan masuk hari ini
		$qty_masuk = DB::table("parking_in")
			->selectRaw("IFNULL(count(*), 0) as qty")
			->whereBetween(DB::raw("DATE(ti_datetime)"), [$today->format('Y-m-d 00:00:00'), $today->format('Y-m-d 23:59:59')])
			->get();
		$masuk_qty = 0;
		foreach($qty_masuk as $d){
			$masuk_qty = $d->qty;
		}
		$data['masuk_qty'] = $masuk_qty;
		
		
		//qty dan income kendaraan keluar
		$rekap_keluar = DB::table("parking_out")
			->selectRaw("IFNULL(count(*), 0) as qty")
			->selectRaw("IFNULL(SUM(parking_fee), 0) as income")
			->whereBetween(DB::raw("DATE(datetimeout)"), [$today->format('Y-m-d 00:00:00'), $today->format('Y-m-d 23:59:59')])
			->get();
			
		$keluar_qty = 0;
		$keluar_income = 0;
		
		foreach($rekap_keluar as $d){
			$keluar_qty = $d->qty;
			$keluar_income = $d->income;
		}
		
		$data['keluar_qty'] = $keluar_qty;
		$data['keluar_income'] = $keluar_income;
		
		//daily
		$daterange = collect();
		for ($date = $start->copy(); $date <= $today; $date->addDay()) {
			$daterange->push($date->format('Y-m-d'));
		}

		// Fetch data in a single query
		$rows = DB::table("parking_out")
			->selectRaw("DATE(datetimeout) as tanggal, IFNULL(SUM(parking_fee), 0) as total_income")
			->whereBetween(DB::raw("DATE(datetimeout)"), [$start->format('Y-m-d'), $today->format('Y-m-d')])
			->groupBy(DB::raw("DATE(datetimeout)"))
			->get()
			->keyBy('tanggal');

		// Prepare data ensuring all dates exist
		$tanggal = [];
		$total = [];

		foreach ($daterange as $tgl) {
			$formattedDate = \Carbon\Carbon::parse($tgl)->format('d-M'); // Format as d-M
			$tanggal[] = "\"$formattedDate\"";
			$total[] = $rows[$tgl]->total_income ?? 0; // Default to 0 if no data
		}

		// Convert arrays to strings
		$data['tanggal_daily'] = implode(',', $tanggal);
		$data['total_daily'] = implode(',', $total);
		
		
		//weekly
		$today = Carbon::today();
		$start = $today->copy()->subWeeks(7)->startOfWeek(); // Start from the beginning of 7 weeks ago

		// Generate weekly date range
		$weekRange = collect();
		for ($date = $start->copy(); $date <= $today; $date->addWeek()) {
			$weekRange->push([
				'date' => $date->format('Y-m-d'),
				'month' => $date->format('M'), // Get month name
				'week_of_month' => ceil($date->day / 7) // Calculate week number in month
			]);
		}

		// Fetch data in a single query grouped by month and week number
		$rows = DB::table("parking_out")
			->selectRaw("DATE_FORMAT(datetimeout, '%Y-%m') as month, CEIL(DAY(datetimeout) / 7) as week_of_month, IFNULL(SUM(parking_fee), 0) as total_income")
			->whereBetween(DB::raw("DATE(datetimeout)"), [$start->format('Y-m-d'), $today->format('Y-m-d')])
			->groupBy(DB::raw("DATE_FORMAT(datetimeout, '%Y-%m'), CEIL(DAY(datetimeout) / 7)"))
			->get()
			->keyBy(function ($row) {
				return $row->month . '-W' . $row->week_of_month;
			});

		// Prepare data ensuring all weeks exist
		$tanggal = [];
		$total = [];

		foreach ($weekRange as $week) {
			$key = date('Y-m', strtotime($week['date'])) . '-W' . $week['week_of_month'];
			$weekLabel = "{$week['month']} #{$week['week_of_month']}";

			$tanggal[] = "\"$weekLabel\""; // Store formatted label
			$total[] = $rows[$key]->total_income ?? 0; // Default to 0 if no data
		}

		// Convert arrays to strings
		$data['tanggal_weekly'] = implode(',', $tanggal);
		$data['total_weekly'] = implode(',', $total);

		
		
		//monthly
		
		$start = Carbon::now()->subMonths(11)->startOfMonth(); // 12 months including current
		$today = Carbon::now()->endOfMonth();

		$daterange = collect();
		for ($date = $start->copy(); $date <= $today; $date->addMonth()) {
			$daterange->push($date->format('Y-m'));
		}

		// Fetch data for the last 12 months
		$rows = DB::table("parking_out")
			->selectRaw("DATE_FORMAT(datetimeout, '%Y-%m') as bulan, IFNULL(SUM(parking_fee), 0) as total_income")
			->whereBetween(DB::raw("DATE(datetimeout)"), [$start->format('Y-m-d'), $today->format('Y-m-d')])
			->groupBy(DB::raw("DATE_FORMAT(datetimeout, '%Y-%m')"))
			->get()
			->keyBy('bulan');

		// Prepare data ensuring all months exist
		$tanggal = [];
		$total = [];

		foreach ($daterange as $bln) {
			$formattedDate = \Carbon\Carbon::createFromFormat('Y-m', $bln)->format('M Y'); // Example: Jan 2024
			$tanggal[] = "\"$formattedDate\"";
			$total[] = $rows[$bln]->total_income ?? 0; // Default to 0 if no data
		}

		// Convert arrays to strings
		$data['tanggal_monthly'] = implode(',', $tanggal);
		$data['total_monthly'] = implode(',', $total);

		return view("summary",$data);
	}
	
	
	function daily(){
		$data['title'] = "Pendapatan Harian";
		$data['title2'] = "Parking income summary for daily, weekly and monthly";
		return view("daily",$data);
	}
	
	
	function daily_data(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		$data = DB::table('parking_out')
		->whereBetween("datetimeout", [$dt1, $dt2])
		->selectRaw("LEFT(datetimeout, 10) AS tanggal")
		->selectRaw("sum(CASE WHEN vehicle = 'MOBIL' THEN 1 ELSE 0 END) AS qty_mobil")
		->selectRaw("sum(CASE WHEN vehicle = 'MOTOR' THEN 1 ELSE 0 END) AS qty_motor")
		->selectRaw("sum(CASE WHEN vehicle = 'BOX' THEN 1 ELSE 0 END) AS qty_box")
		->selectRaw("sum(CASE WHEN vehicle NOT IN('MOBIL','MOTOR','BOX') THEN 1 ELSE 0 END) AS qty_other")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOBIL' THEN parking_fee ELSE 0 END) AS mobil")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOTOR' THEN parking_fee ELSE 0 END) AS motor")
		->selectRaw("SUM(CASE WHEN vehicle = 'BOX' THEN parking_fee ELSE 0 END) AS box")
		->selectRaw("SUM(CASE WHEN vehicle NOT IN('MOBIL','MOTOR','BOX') THEN parking_fee ELSE 0 END) AS other")
		->groupBy('tanggal')
		->get();

		
		$table = "<br><br><table class='table table-striped table-bordered table-sm' style='width:100%'><thead style='background-color:#1abc9c;color:#FFF;text-align:center'>
			<tr>
				<th rowspan=2>Tanggal</th>
				<th colspan=2>Mobil</th>
				<th colspan=2>Motor</th>
				<th colspan=2>Box</th>
				<th colspan=2>Lainnya</th>
				<th colspan=2>Total</th>
			</tr>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
			</tr>
		</thead><tbody>";
		$grandtotal = 0;
		$grandtotal_qty = 0;
		$subtotal_qty = 0;
		$subtotal = 0;
		$subtotal_mobil_qty = 0;
		$subtotal_mobil = 0;
		$subtotal_motor_qty = 0;
		$subtotal_motor = 0;
		$subtotal_box_qty = 0;
		$subtotal_box = 0;
		$subtotal_other_qty = 0;
		$subtotal_other = 0;
		foreach($data as $d){
			$subtotal_mobil_qty += $d->qty_mobil;
			$subtotal_mobil += $d->mobil;
			$subtotal_motor_qty += $d->qty_motor;
			$subtotal_motor += $d->motor;
			$subtotal_box_qty += $d->qty_box;
			$subtotal_box += $d->box;
			$subtotal_other_qty += $d->qty_other;
			$subtotal_other += $d->other;
			$subtotal_qty = $d->qty_motor + $d->qty_mobil + $d->qty_box +  $d->qty_other;
			$subtotal = $d->motor + $d->mobil + $d->box +  $d->other;
			$grandtotal += $subtotal;
			$grandtotal_qty += $subtotal_qty;
			$table .= "<tr>
							<td align=center>".date_format(date_create($d->tanggal),"d M y")."</td>
							<td align=right>".number_format($d->qty_mobil)."</td>
							<td align=right>".number_format($d->mobil)."</td>
							<td align=right>".number_format($d->qty_motor)."</td>
							<td align=right>".number_format($d->motor)."</td>
							<td align=right>".number_format($d->qty_box)."</td>
							<td align=right>".number_format($d->box)."</td>
							<td align=right>".number_format($d->qty_other)."</td>
							<td align=right>".number_format($d->other)."</td>
							<td align=right>".number_format($subtotal_qty)."</td>
							<td align=right>".number_format($subtotal)."</td>
							</tr>";
			$subtotal = 0;
					
		}
		$table .= "</tbody><tfoot style='background-color:#1abc9c;color:#FFF;font-weight:bolder'>
			<tr>
				<td>TOTAL</td>
				<td align=right>".number_format($subtotal_mobil_qty)."</td>
				<td align=right>".number_format($subtotal_mobil)."</td>
				<td align=right>".number_format($subtotal_motor_qty)."</td>
				<td align=right>".number_format($subtotal_motor)."</td>
				<td align=right>".number_format($subtotal_box_qty)."</td>
				<td align=right>".number_format($subtotal_box)."</td>
				<td align=right>".number_format($subtotal_other_qty)."</td>
				<td align=right>".number_format($subtotal_other)."</td>
				<td align=right>".number_format($grandtotal_qty)."</td>
				<td align=right>".number_format($grandtotal)."</td>
				</tr></tfoot>
				</table>";

		return $table;
		
	}
	function daily_graphic(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		
		$data = DB::table('parking_out')
		->whereBetween("datetimeout", [$dt1, $dt2])
		//->selectRaw("LEFT(datetimeout, 10) AS tanggal")
		->selectRaw("date_format(datetimeout, '%d %b %y') AS tanggal")
		->selectRaw("sum(CASE WHEN vehicle = 'MOBIL' THEN 1 ELSE 0 END) AS qty_mobil")
		->selectRaw("sum(CASE WHEN vehicle = 'MOTOR' THEN 1 ELSE 0 END) AS qty_motor")
		->selectRaw("sum(CASE WHEN vehicle = 'BOX' THEN 1 ELSE 0 END) AS qty_box")
		->selectRaw("sum(CASE WHEN vehicle NOT IN('MOBIL','MOTOR','BOX') THEN 1 ELSE 0 END) AS qty_other")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOBIL' THEN parking_fee ELSE 0 END) AS mobil")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOTOR' THEN parking_fee ELSE 0 END) AS motor")
		->selectRaw("SUM(CASE WHEN vehicle = 'BOX' THEN parking_fee ELSE 0 END) AS box")
		->selectRaw("SUM(CASE WHEN vehicle NOT IN('MOBIL','MOTOR','BOX') THEN parking_fee ELSE 0 END) AS other")
		->groupBy('tanggal')
		->orderBy('datetimeout')
		->get();

		return response()->json($data);
	}
	
	function daily_graphic_pie(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		
		$data = DB::table('parking_out')
		->whereBetween("datetimeout", [$dt1, $dt2])
		->selectRaw("vehicle")
		->selectRaw("sum(parking_fee) as amount")
		->selectRaw("count(*) as qty")
		->groupBy('vehicle')
		->get();

		return response()->json($data);
	}
}
