@extends('layouts.app')

@section('content')
<div class="main-card mb-3 card">
	<div class="card-body">
	<h5 class="card-title"></h5>
		<div class="row">
		<form id="frmfilter" class="form-inline">
		<div class="mb-2 mr-sm-2 mb-sm-0 position-relative form-group">
			<label for="date1" class="mr-sm-2">Tanggal</label>
			<input name="date1" id="date1"  type="text" class="form-control dtime" value="<?php echo date('Y-m-d', strtotime('-7 days')); ?>" readonly>
		</div>
			<button type="button" class="btn btn-primary" onclick="submitForm()">SUBMIT</button>
			</form>
		</div>

		<br>
		<div class="main-card mb-3 card">
			<div class="card-header-tab card-header-tab-animation card-header">
				<div class="card-header-title">
					Statistik Jam Masuk
				</div>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-sm-12">
						<canvas id="myChartMasukStatistik" style="height:300px"></canvas>
					</div>
				</div>
			</div>
		</div>
		
		<div class="main-card mb-3 card">
			<div class="card-header-tab card-header-tab-animation card-header">
				<div class="card-header-title">
					Statistik Jam Keluar
				</div>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-sm-12">
						<canvas id="myChartKeluarStatistik" style="height:300px"></canvas>
					</div>
				</div>
			</div>
		</div>
		
		
	</div>
</div>
		

@endsection
@section('custom-script')
<script>
$('.dtime').datepicker({
    format: 'yyyy-mm-dd'
});
submitForm();


function submitForm(){
    const startDate = $("#date1").val();
    fetch("{{url('statistics/graphic')}}", {
        method: 'POST',
        headers: { 
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
        },
        body: JSON.stringify({ date1: startDate })
    })
    .then(response => response.json())
    .then(data => {
        const labels = JSON.parse(data.jam);
        const chars = JSON.parse(data.chars);

        const ctx = document.getElementById('myChartMasukStatistik').getContext('2d');
        if (window.myChartMasukStatistik instanceof Chart) {
            window.myChartMasukStatistik.destroy();
        }

        window.myChartMasukStatistik = new Chart(ctx, {
            type: "line",
            data: {
                labels: labels,
                datasets: chars
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: false
                    },
                    x: {
                        ticks: {
                            color: 'black'
                        }
                    }
                }
            }
        });
    })
    .catch(error => console.error('Error fetching data:', error));
	
	submitFormKeluar();
}
function submitFormKeluar(){
    const startDate = $("#date1").val();
    fetch("{{url('statistics/graphic_keluar')}}", {
        method: 'POST',
        headers: { 
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
        },
        body: JSON.stringify({ date1: startDate })
    })
    .then(response => response.json())
    .then(data => {
        const labels = JSON.parse(data.jam);
        const chars = JSON.parse(data.chars);

        const ctx = document.getElementById('myChartKeluarStatistik').getContext('2d');
        if (window.myChartKeluarStatistik instanceof Chart) {
            window.myChartKeluarStatistik.destroy();
        }

        window.myChartKeluarStatistik = new Chart(ctx, {
            type: "line",
            data: {
                labels: labels,
                datasets: chars
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: false
                    },
                    x: {
                        ticks: {
                            color: 'black'
                        }
                    }
                }
            }
        });
    })
    .catch(error => console.error('Error fetching data:', error));
}



</script>
@endsection