<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::post('/sync/{id}', [App\Http\Controllers\SyncController::class, 'syncData'])->name('syncData');
Route::get('/', function () {
    return view('auth/login');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\DashboardController::class, 'summary'])->middleware('auth')->name('summary');
Route::get('/summary', [App\Http\Controllers\DashboardController::class, 'summary'])->middleware('auth')->name('summary');
Route::get('/daily', [App\Http\Controllers\DashboardController::class, 'daily'])->middleware('auth')->name('daily');
Route::get('/monthly', [App\Http\Controllers\DashboardController::class, 'daily'])->middleware('auth')->name('daily');
Route::post('/daily/data', [App\Http\Controllers\DashboardController::class, 'daily_data'])->middleware('auth')->name('daily_data');
Route::post('/daily/graphic', [App\Http\Controllers\DashboardController::class, 'daily_graphic'])->middleware('auth')->name('daily_graphic');
Route::post('/daily/graphic_pie', [App\Http\Controllers\DashboardController::class, 'daily_graphic_pie'])->middleware('auth')->name('daily_graphic_pie');

Route::get('/monthly', [App\Http\Controllers\DashboardControllerMonthly::class, 'monthly'])->middleware('auth')->name('monthly');
Route::post('/monthly/data', [App\Http\Controllers\DashboardControllerMonthly::class, 'monthly_data'])->middleware('auth')->name('monthly_data');
Route::post('/monthly/graphic', [App\Http\Controllers\DashboardControllerMonthly::class, 'monthly_graphic'])->middleware('auth')->name('monthly_graphic');
Route::post('/monthly/graphic_pie', [App\Http\Controllers\DashboardControllerMonthly::class, 'monthly_graphic_pie'])->middleware('auth')->name('monthly_graphic_pie');


Route::get('/statistics', [App\Http\Controllers\StatisticController::class, 'index'])->middleware('auth')->name('index');
Route::post('/statistics/graphic', [App\Http\Controllers\StatisticController::class, 'graphic'])->middleware('auth')->name('graphic');
Route::post('/statistics/graphic_keluar', [App\Http\Controllers\StatisticController::class, 'graphic_keluar'])->middleware('auth')->name('graphic_keluar');


Route::get('/nopol', [App\Http\Controllers\LanggananController::class, 'nopol'])->middleware('auth')->name('nopol');
Route::post('/nopol/detail', [App\Http\Controllers\LanggananController::class, 'nopol_detail'])->middleware('auth')->name('nopol_detail');

Route::get('/kartu', [App\Http\Controllers\LanggananController::class, 'kartu'])->middleware('auth')->name('kartu');
Route::post('/kartu/detail', [App\Http\Controllers\LanggananController::class, 'kartu_detail'])->middleware('auth')->name('kartu_detail');

Route::get('/penjualan', [App\Http\Controllers\LanggananController::class, 'penjualan'])->middleware('auth')->name('penjualan');
Route::post('/penjualan/data', [App\Http\Controllers\LanggananController::class, 'penjualan_data'])->middleware('auth')->name('penjualan_data');

Route::get('/account', [App\Http\Controllers\AccountController::class, 'index'])->middleware('auth')->name('index');
Route::post('/account', [App\Http\Controllers\AccountController::class, 'update'])->middleware('auth')->name('update');


