

<?php $__env->startSection('content'); ?>
<div class="main-card mb-3 card">
	<div class="card-body">
	<h5 class="card-title"></h5>
		<div class="row">
		<form id="frmfilter" class="form-inline">
		<div class="mb-2 mr-sm-2 mb-sm-0 position-relative form-group">
			<label for="date1" class="mr-sm-2">Tanggal</label>
			<input name="date1" id="date1"  type="text" class="form-control dtime" value="<?php echo date('Y-m-d', strtotime('-7 days')); ?>" readonly>
		</div>
		<div class="mb-2 mr-sm-2 mb-sm-0 position-relative form-group">
			<label for="date2" class="mr-sm-2">Sd</label>
			<input name="date2" id="date2"  type="text" class="form-control dtime" value="<?php echo date('Y-m-d'); ?>" readonly>
		</div>																																									   
			<button type="button" class="btn btn-primary" onclick="submitForm()">SUBMIT</button>
			</form>
		</div>
		<br>
		<div class="main-card mb-3 card">
			<div class="card-header-tab card-header-tab-animation card-header">
				<div class="card-header-title">
					Income dan Quantity
				</div>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-sm-6">
					<p class="text-center">Income</p>
						<canvas id="parkingChartPie" style="height:300px" style="padding:10px; radius:5px;background-color:#ecf0f1"></canvas>
					</div>
					<div class="col-sm-6">
					<p class="text-center">Quantity</p>
						<canvas id="parkingChartPie2" style="height:300px" style="padding:10px; radius:5px;background-color:#ecf0f1"></canvas>
					</div>
				</div>
			</div>
		</div>
		
		<div class="main-card mb-3 card">
			<div class="card-header-tab card-header-tab-animation card-header">
				<div class="card-header-title">
					Graphic Income
				</div>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-sm-12">
						<canvas id="parkingChart" style="height:300px"></canvas>
					</div>
				</div>
			</div>
		</div>
		
		<div class="main-card mb-3 card">
			<div class="card-header-tab card-header-tab-animation card-header">
				<div class="card-header-title">
					Income Pertanggal
				</div>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-sm-12">
						<div id="dresponse"></div>
					</div>
				</div>
				
			</div>

		</div>
	</div>
</div>
		

<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-script'); ?>
<script>
$('.dtime').datepicker({
    format: 'yyyy-mm-dd'
});
submitForm();

function submitForm(){
	$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
			}
		});
		$.ajax({
			type : "POST",
			url  : "<?php echo e(url('daily/data')); ?>",
			data : $("#frmfilter").serialize(),
			beforeSend: function() {
					
			},
			success: function(data){
				$("#dresponse").empty(); 
				$('#dresponse').html(data);	
			}
		});
		getData();
		getDataPie();
}

function getData(){
    const startDate = $("#date1").val();
    const endDate = $("#date2").val();
    
    fetch("<?php echo e(url('daily/graphic')); ?>", {
        method: 'POST',
        headers: { 
			'Content-Type': 'application/x-www-form-urlencoded',
			'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')	
			},
        body: `date1=${startDate}&date2=${endDate}`
    })
    .then(response => response.json())
    .then(data => {
        const labels = data.map(item => item.tanggal);
        const mobilData = data.map(item => item.mobil);
        const motorData = data.map(item => item.motor);
        const boxData = data.map(item => item.box);
        const otherData = data.map(item => item.other);

        const ctx = document.getElementById('parkingChart').getContext('2d');
        if (window.parkingChart instanceof Chart) {
            window.parkingChart.destroy();
        }
		
		
		
        window.parkingChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [
                    { label: 'Mobil', data: mobilData, backgroundColor: '#00BFFF' },
                    { label: 'Motor', data: motorData, backgroundColor: '#7FFF00' },
                    { label: 'Box', data: boxData, backgroundColor: '#4876FF' },
                    { label: 'Other', data: otherData, backgroundColor: '#0f2091' }
                ]
            },
            options: {
                responsive: true,
				tooltips: {
							mode: 'label',
							label: 'mylabel',
							callbacks: {
								label: function(tooltipItem, data) {
									return tooltipItem.yLabel.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								},
							},
						},
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });
		
    })
    .catch(error => console.error('Error fetching data:', error));
}

function getDataPie(){
    const startDate = $("#date1").val();
    const endDate = $("#date2").val();
    const barColors = window.bgs;
    fetch("<?php echo e(url('daily/graphic_pie')); ?>", {
        method: 'POST',
        headers: { 
			'Content-Type': 'application/x-www-form-urlencoded',
			'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')	
			},
        body: `date1=${startDate}&date2=${endDate}`
    })
    .then(response => response.json())
    .then(data => {
        const labels = data.map(item => item.vehicle);
        const amount = data.map(item => item.amount);
        const qty = data.map(item => item.qty);
		
        const ctx = document.getElementById('parkingChartPie').getContext('2d');
        if (window.parkingChartPie instanceof Chart) {
            window.parkingChartPie.destroy();
        }
		//amount
        window.parkingChartPie = new Chart(ctx, {
            type: 'pie',
            data: {
                labels: labels,
                datasets: [{
                    data : amount,
					backgroundColor: barColors
				} ]
            },
            options: {
                responsive: true,
				plugins: {
					tooltip: {
					  
					  callbacks: {
						label: function(tooltipItem) {
						  var value = tooltipItem.raw.toLocaleString(); // Format with thousand separator
						  return `${tooltipItem.label}: ${value}`;
						}
					  }
          
					  
					  
					}
				}
            },
			
        });
		
		//voulume
		const ctx2 = document.getElementById('parkingChartPie2').getContext('2d');
        if (window.parkingChartPie2 instanceof Chart) {
            window.parkingChartPie2.destroy();
        }
		
        window.parkingChartPie2 = new Chart(ctx2, {
            type: 'pie',
            data: {
                labels: labels,
                datasets: [{
                    data : qty,
					backgroundColor: barColors
				} ]
            },
            options: {
                responsive: true,
            }
        });
		
    })
    .catch(error => console.error('Error fetching data:', error));
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SSD H\xampp\htdocs\kedoya\resources\views/daily.blade.php ENDPATH**/ ?>